#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"
#include "../rtjpeg/RTjpeg.h"
#include "areaDeinterlace.h"

#include "rtjpeg_plugin.h"

//FIXME
double rtjpeg_pel_ratio() 
{
  return 1.0;
}
/* dynamic loading stuff */
#if defined(DYNAMIC_LOADING) 
/* dummy symbol for telling the plugin architecture we can load video */
int video_in(void)
{
	return 1;
}

int check_file(char *name) { return rtjpeg_check_sig(name); }
int open_file(char *name) { return rtjpeg_open(name); }
int close_file() { return rtjpeg_close() ;}
int eof_file() { return rtjpeg_end_of_video(); }
int get_video_width() { return rtjpeg_get_video_width(); }
int get_video_height() { return rtjpeg_get_video_height(); }
double get_video_framerate() { return rtjpeg_get_video_frame_rate(); }
double pel_ratio() { return rtjpeg_pel_ratio(); }




void read_rtjpeg(unsigned char **frame, unsigned int number);

void read_frame(unsigned char **frame, unsigned int number)
{
	read_rtjpeg(frame,number);
}
//void (*read_frame)(unsigned char **, int)=read_rtjpeg;

#endif

void border_extend(frame,w1,h1,w2,h2);

/* ----------------------------------------------------------- */
/* yuv420 version for speed                                    */
/* ----------------------------------------------------------- */

void read_rtjpeg(frame, number)
unsigned char *frame[];
unsigned int number;
{
  int xpos,ypos,f,tmp;
  unsigned char *dst = NULL;
  char buf[32];
  char frametype[1]; // dummy for rtjpeg_get_frame
  int audiolen;

  int i, j;
  char name[128];
  static int yuv_size_y;
  static int yuv_size_uv;
  static unsigned char *p_yuv;

  static int    mostrecent = 0;
  static size_t    bufsize;
  char *audio;
  int    timecode;


  // fprintf(stderr," chroma444=%d  chroma422=%d  chroma420=%d chroma=%d\n",
  //         CHROMA444, CHROMA422, CHROMA420, chroma_format);

#ifndef DYNAMIC_LOADING
  if (chroma_format != CHROMA420) {
    fprintf(stderr, "\n%s\n\n", "rtjpeg_plugin only supports YUV420!, sorry");
    exit(1);
  }
#endif
  if (!mostrecent) { // first frame to encode, number may be != 0
    bufsize = rtjpeg_get_video_height()*rtjpeg_get_video_width()*1.5; // we get YUV420
    yuv_size_y  = rtjpeg_get_video_width()*rtjpeg_get_video_height();
    yuv_size_uv = yuv_size_y >> 2;
  }
  
/*  fprintf(stderr,"\nframenum: %i\n",number); */
  while (mostrecent < number || mostrecent == 0) {
    mostrecent++;
    // we want only video frames => 1 (onlyvideo)
    p_yuv = rtjpeg_get_frame(mostrecent, &timecode, 1, &audio, &audiolen); 
  }

#ifndef DYNAMIC_LOADING
  // if rtjpeg end of file
  if(rtjpeg_end_of_video()) {
    frames_scaled = 0; /* Terminate encoding */
    // fprintf(stderr, "%s nframes=%d\n", "end of file in rtjpg", nframes);
  }
#endif

  // now we copy the yuv picture to the parial frames frame[0..2]

  memcpy(frame[0], (void *) p_yuv, yuv_size_y);

  memcpy(frame[1], (void *)(p_yuv+yuv_size_y), yuv_size_uv);
  memcpy(frame[2], (void *)(p_yuv+yuv_size_y+yuv_size_uv), yuv_size_uv);

}

