/* protocol.c */
void find_frame(struct nit *n, struct rpl_packet *in);
int file_data_frame(struct nit *n, struct client *c);
void send_file_frame(struct nit *n, struct rpl_packet *in);
void rpl_packet_recvd_callback(struct nit *n, struct rpl_packet *p);
/* linux-ps.c */
void nit_close(struct nit *n);
struct nit *nit_open(char *name);
void nit_send_frame(struct nit *n, unsigned char *frame, int len);
void nit_multicast(struct nit *n, unsigned char *mcaddr);
int nit_read_packet(struct nit *n, char *buf, int len, struct timeval *tv);
/* rpld.c */
int main(int argc, char **argv);
/* util.c */
unsigned char *ethtoa(void *in);
void daemonize(void);
/* rpl.c */
int write_char(unsigned char *ptr, u8 v);
int write_short(unsigned char *ptr, u16 v);
int write_long(unsigned char *ptr, u32 v);
int put_char(unsigned char *ptr, u16 token, u8 value);
int put_short(unsigned char *ptr, u16 token, u16 value);
int put_long(unsigned char *ptr, u16 token, u32 value);
int put_mac(unsigned char *ptr, u16 token, unsigned char *mac);
void rpl_send_packet(struct nit *n, unsigned char *d, struct rpl_packet *p);
void rpl_packet_recvd(struct nit *n, unsigned char *pptr, int plen);
/* llc.c */
void send_llc_frame(struct nit *n, unsigned char dsap, unsigned char ssap, unsigned char *dmac, unsigned char *ibuf, int len);
void llc_recv_packet(struct nit *n, unsigned char *buf, int len);
/* client.c */
void cache_locally(struct clfile *f);
struct client *find_client_by_mac(unsigned char *mac);
void client_calc_offsets(struct client *c);
void client_get_block(struct client *c, struct rpl_packet *p);
int client_last_block(struct client *c);
void client_flush_cache(struct client *c);
int clients_check_status(void);
int client_dispatch(struct nit *n);
/* config.c */
void do_linux_kernel(struct client *c, struct clfile *f);
void parse_config(void);
