#ifndef f_AVIAUDIOOUTPUT_H
#define f_AVIAUDIOOUTPUT_H

#include <windows.h>

class AVIAudioOutputBuffer {
public:
	AVIAudioOutputBuffer *next,*prev;
	WAVEHDR hdr;
	DWORD dwBytesInBuffer;

	AVIAudioOutputBuffer(long bsize);
	~AVIAudioOutputBuffer();
	BOOL init(HWAVEOUT hWaveOut);
	BOOL post(HWAVEOUT hWaveOut);
	void deinit(HWAVEOUT hWaveOut);
};

class AVIAudioOutput {
private:
	AVIAudioOutputBuffer *pending, *pending_tail, *active;
	long bufsize;
	int numbufs, maxbufs;
	HWAVEOUT hWaveOut;
	HANDLE hEventBuffersFree;
	char fill_byte;
	DWORD nSamplesPerSec;
	DWORD nAvgBytesPerSec;
	int iBuffersActive;
	long lAvailSpace;

	enum {
		STATE_NONE		= 0,
		STATE_OPENED	= 1,
		STATE_PLAYING	= 2,
		STATE_SILENT	= 10,
	} curState;

	BOOL postBuffer(AVIAudioOutputBuffer *aaob);
public:
	AVIAudioOutput(long bufsize, int maxbufs);
	~AVIAudioOutput();

	BOOL init(WAVEFORMATEX *wf);
	void go_silent();
	BOOL isSilent();
	BOOL start();
	BOOL checkBuffers();
	BOOL waitBuffers(DWORD timeout);
	long avail();
	BOOL write(void *data, long len, DWORD timeout);
	BOOL stop();
	BOOL finalize(DWORD timeout);
	void flush();
	long position();
	bool isFrozen();
};

#endif
