#ifndef f_FRAMESUBSET_H
#define f_FRAMESUBSET_H

#include "List.h"

class FrameSubsetNode : public ListNode2<FrameSubsetNode> {
friend class FrameSubset;
public:
	int start, len;

	FrameSubsetNode() {};
	FrameSubsetNode(int _s, int _l) : start(_s), len(_l) {}
};

class FrameSubset {
public:
	FrameSubset();
	FrameSubset(int length);
	~FrameSubset();

	int getTotalFrames();
	void addRange(int start, int len);
	void addRangeMerge(int start, int len);
	int lookupFrame(int frame);
	int revLookupFrame(int frame);
	int lookupRange(int start, int& len);
	void deleteRange(int start, int len);
	FrameSubsetNode *getFirstFrame() {
		FrameSubsetNode *fsn = list.AtHead();

		if (fsn->NextFromHead())
			return fsn;
		else
			return 0;
	}
	FrameSubsetNode *getNextFrame(FrameSubsetNode *fsn) {
		fsn = fsn->NextFromHead();

		if (fsn->NextFromHead())
			return fsn;
		else
			return 0;
	}

private:
	List2<FrameSubsetNode> list;

	void deleteNode(FrameSubsetNode *pfsn);
	FrameSubsetNode *findNode(int& poffset, int iDstFrame);
};

#endif
