#ifndef f_FHT_H
#define f_FHT_H

// based on:
//
//------------------------------------
//  fft.cpp
//  The implementation of the 
//  Fast Fourier Transform algorithm
//  (c) Reliable Software, 1996
//------------------------------------
//
// but now it's an FHT (Fast Hartley Transform)...

class Fht
{
public:
    Fht (int Points, long sampleRate);
    ~Fht ();
    int     Points () const { return _Points; }
    void    Transform (int width);
    void    CopyInStereo8 (unsigned char *samples, int count);
    void    CopyInMono8 (unsigned char *samples, int count);
    void    CopyInStereo16 (signed short *samples, int count);
    void    CopyInMono16 (signed short *samples, int count);

    double  GetIntensity (int i) const
    { 
        return R[i];
    }

    int     GetFrequency (int point) const
    {
        // return frequency in Hz of a given point
        long x =_sampleRate * point;
        return x / _Points;
    }

    int     HzToPoint (int freq) const 
    { 
        return (long)_Points * freq / _sampleRate; 
    }

    int     MaxFreq() const { return _sampleRate; }

    int     Tape (int i) const
    {
        return (int) aTape[i];
    }

private:
    int			_Points;
    long		_sampleRate;

	int			bits;

	float		*aTape;
	float		*sinTab;
	int			*bRevTab;
	float		*A, *B, *R, *W;
};

#endif
