#ifndef f_PREFS_H
#define f_PREFS_H

#include <windows.h>

///////////////////////////////////////////////////////////////////////////

class PreferencesMain {
public:
	enum {
		DEPTH_FASTEST	= 0,
		DEPTH_OUTPUT	= 1,
		DEPTH_DISPLAY	= 2,
		DEPTH_16BIT		= 3,
		DEPTH_24BIT		= 4,
		DEPTH_32BIT		= 5,

		OPTF_FORCE		= 0x01,
		OPTF_FPU		= 0x02,
		OPTF_MMX		= 0x04,
	};

	char	iPreviewPriority;
	char	iPreviewDepth;
	char	iDubPriority;
	char	fAttachExtension;
	char	fOptimizations;
};

class PreferencesScene {
public:
	int		iCutThreshold;
	int		iFadeThreshold;
};

class Preferences {
public:
	PreferencesMain	main;
	PreferencesScene scene;

	enum {
		DISPF_DITHER16	= 0x01,
	};

	char fDisplay;
	char fAVIRestrict1Gb;
	char fNoCorrectLayer3;
};

///////////////////////////////////////////////////////////////////////////

BOOL APIENTRY PreferencesDlgProc		( HWND hDlg, UINT message, UINT wParam, LONG lParam);

///////////////////////////////////////////////////////////////////////////

#ifndef f_PREFS_CPP
extern Preferences		g_prefs;
#endif

void LoadPreferences();

#endif
