%{
#include <stdlib.h>
#include "list.h"
#include "parser.yy.h"
#include "oxout.h"

char *lexeme(void)
{
  char *ret;
  if ((ret=(char*)malloc(yyleng+1))==NULL) exit(-1);
  strcpy(ret,yytext);

  return(ret);
}

%}
%option noyywrap

CHAR				[A-Za-z]
DIGIT				[0-9]

%%
extern				return(EXTERN);
func				return(FUNC);
end				return(END);
if				return(IF);
then				return(THEN);
elseif				return(ELSEIF);
else				return(ELSE);

"("				return(BOPEN);
")"				return(BCLOSE);
"+"				return(PLUS);
"-"				return(MINUS);
"*"				return(MULT);
"<"				return(LESS);
";"				return(SEMI);
"="				return(EQUAL);

{DIGIT}+			{
				  return(INT);
                                  @{@INT.text@=lexeme();@}
				}
{CHAR}({CHAR}|{DIGIT}|"_")*	{
				  return(IDENT);
                                  @{@IDENT.text@=lexeme();@}
				}

[ \t\n]				/* eat up whitespaces */
.				fprintf(stderr,"lexical error\n");exit(2);
%%

