%{
#include "parser.tab.h"
%}
%option noyywrap

CHAR				[A-Za-z]
DIGIT				[0-9]

%%
extern				return(EXTERN);
func				return(FUNC);
end				return(END);
if				return(IF);
then				return(THEN);
elseif				return(ELSEIF);
else				return(ELSE);

"("				return(BOPEN);
")"				return(BCLOSE);
"+"				return(PLUS);
"-"				return(MINUS);
"*"				return(MULT);
"<"				return(LESS);
";"				return(SEMI);
"="				return(EQUAL);

{DIGIT}+			return(INT);
{CHAR}({CHAR}|{DIGIT}|"_")*	return(IDENT);

[ \t\n]				/* eat up whitespaces */
.				exit(2);
%%

