%token EXTERN FUNC END IF THEN ELSEIF ELSE 
%token BOPEN BCLOSE PLUS MINUS MULT LESS SEMI EQUAL 
%token INT IDENT 
%%

program	        : 
                | decl SEMI program
		;

decl		: IDENT EQUAL functext 
		;

functext	: function
		| EXTERN
		;

expr		: function
		| IF expr THEN expr elsifthenexpr ELSE expr END IF
                | expr BOPEN expr BCLOSE
		| MINUS term plusminusterm 
		| term plusminusterm 
		| term multerm
		| term LESS term
		;

elsifthenexpr	: 
                | ELSEIF expr THEN expr elsifthenexpr
		;

plusminus	: PLUS 
		| MINUS
		;

plusminusterm	: 
                | plusminus term plusminusterm
		;

multerm		: MULT term
                | MULT term multerm
		;

function	: FUNC BOPEN IDENT BCLOSE expr END FUNC
		;
		

term		: BOPEN expr BCLOSE
		| IDENT
		| INT
		;
		
%%

#include <stdio.h>

int yyerror()
{
  printf("Error occurred\n");
  exit(1);
}

int main(int argc, char *argv[])
{
  if(yyparse() == 1) {
    fprintf(stderr, "ERRORR ccured\n");
    exit(1);
  }
  exit(0);
}
