module Aufgabe9 where

-- listFilt

listFilt :: (a->Bool) -> [[a]] -> [[a]]
listFilt f a = map (filter (f)) a

fOne :: String -> Bool
fOne a 
  | a == "" = True
  | ((length a) `mod` 2) == 1 = False
  | inRange ('A','Z') (head a) = False
  | otherwise = True

fTwo :: Integer -> Bool
fTwo a = if ((last (takeWhile (<=a) (fib 0 1 []))) == a) then True else False where
  fib a b c = [a] ++ (fib b (a+b) c)

fThree :: String -> Bool
fThree a = (isPal a) where
  isPal :: String -> Bool
  isPal x = (if x == [] then True else isPal' x) where
    isPal' (h:t) 
        | t == [] = True
        | [h] == t = True
        | [h] == [last t] = isPal (init t)
        | otherwise = False

extractSet :: Eq a => [a] -> [a]
extractSet [] = []
extractSet a = uniq (unsort a) where
  uniq :: Eq a => [a] -> [a]
  uniq s = (if s == [] then [] else foldr1 (\(l1:x1) -> \(l2:x2) -> if l1 == l2 then [l1] ++ x2 else [l1] ++ [l2] ++ x2)  (map (\l -> [l]) s))

unsort :: Eq a => [a] -> [a]
unsort = foldl (\s -> \t -> (\(u, v) -> u++[t]++v) (break (==t) s)  ) []

union, diff, inters :: Eq a => [a] -> [a] -> [a]
union a b = extractSet (a ++ b)
inters a b = filter (\l -> elem l a) b
diff a b = (filter (\l -> not (elem l b)) a)

isSet :: Eq a => [a] -> Bool
isSet a = (unsort a) == (extractSet a)

isEqual :: Eq a => [a] -> [a] -> Bool
isEqual a b = (diff a b) == [] && (union a b) == a 

isElem :: Eq a => a -> [a] -> Bool
isElem a b = elem a b

